package com.crihexe.hiddenviewsmind.mapper;

import com.crihexe.hiddenviewsmind.db.entities.PostEntity;
import com.crihexe.hiddenviewsmind.db.mongo.PostingQueueMongo;
import com.crihexe.hiddenviewsmind.db.mongo.UserTagEntityAndMongo;
import com.crihexe.hiddenviewsmind.dto.Post;
import com.crihexe.hiddenviewsmind.dto.UserTagImage;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

@Mapper(componentModel = "spring")
public interface PostMapper {
    @Mapping(target = "userTags", ignore = true)
    Post toDto(PostEntity postEntity);

    @Mapping(target = "userTags", ignore = true)
    Post toDto(PostingQueueMongo mongoDoc);

    @Mapping(source = "children", target = "children.container_id")
    PostEntity toEntity(Post postDto);

    @Mapping(target = "children", ignore = true)
    PostingQueueMongo toMongoDocument(Post postDto);

    PostEntity toEntity(PostingQueueMongo mongoDoc);

    PostingQueueMongo toMongoDocument(PostEntity postEntity);

}
